//The Z6427 is a station that can connect to an AP with these credentials:
#define APSSID "KeyesWifi_S"
#define APPSK "KeyesWifi"
//at this port
//need to find out IP address of stations to connect
const uint16_t port = 8080;

const char* ssid = APSSID;
const char* password = APPSK;

//for Pico:
#include <WiFi.h>
//WiFiMulti multi;

WiFiClient client;
IPAddress apIP,staIP; 
struct station_info *stat_info;
char relayState=0;

void setup() {
  Serial.begin(115200);
  while(!Serial && millis()<5000){}   //wait for serial with timeout
  Serial.println("Starting");
  if(!WiFi.softAP(ssid,password,1,0,4)){  //channel 1, visible AP, 4 stations
    Serial.println("Unable to set up AP, rebooting in 10 seconds...");
    delay(10000);
    rp2040.reboot();
  }
  apIP=WiFi.localIP();
  staIP=apIP;   //same subnet, so most octets are the same
  Serial.println("AP up, IP address: ");
  Serial.println(apIP);    
  Serial.println("Type 0 or 1 to set relay.");
  Serial.println(WiFi.softAPmacAddress());
  Serial.println(WiFi.getHostname());
}

void loop() {  
  int i,d;
  client.setTimeout(500);  
  Serial.printf("%d stations connected.\r\n",WiFi.softAPgetStationNum());
  for(i=DHCPS_BASE_IP;i<DHCPS_BASE_IP+DHCPS_MAX_IP;i++){    //these are defined in dhcpserver.h for Pico W
    if(i!=apIP[3]){   //don't ping host
      staIP[3]=i;      
      if(client.connect(staIP, port)){
        Serial.print(staIP);
        Serial.println(" OK");   
        if(relayState==0){
          client.print("PIN00=1");
        }else if(relayState==1){
          client.print("PIN00=0");
        }
        delay(100);   //wait for response
        if(client.available()){
          Serial.print("Received from server:[");
          while(client.available()){
            Serial.write(client.read());
          }
          Serial.println("]");
        }
      }
      client.stop();  
    }
  }
  while(Serial.available()){
    d=Serial.read();
    if(d=='0'){
      Serial.println("Turning off.");
      relayState=0;
    }else if(d=='1'){
      Serial.println("Turning on.");
      relayState=1;
    }
  }
}
